jQuery(document).ready(function(){
	$("#seccionEstadoTramitacion_legend").on("click",function(){$("#seccionEstadoTramitacion").toggle();});	
	
	cargarCombos();
	
	if(esUsuarioModificacion){
		$("#expFiltro_toolbar").addButton({i18nCaption:"cerrarExpedientes",right:false, click:cerrarExpedientes},$.rup.i18n.app["botones"]);	
	
		$("#expFiltro").rup_table({
			url: "../expedientesCierre",
			colNames: [
				$.rup.i18n.app.expedientes.expediente,
				$.rup.i18n.app.expedientes.fecReg,
				$.rup.i18n.app.expedientes.cifNif,
				$.rup.i18n.app.expedientes.razonSocial,
				//$.rup.i18n.app.expedientes.provTrabajo,
				//$.rup.i18n.app.expedientes.munTrabajo,
				//$.rup.i18n.app.expedientes.fInicioTrabajo,
				$.rup.i18n.app.expedientes.fase,
				$.rup.i18n.app.expedientes.tramite
			],
			colModel: [
				{ 	name: "idExpediente",
					align: "right", 
					width: 90, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fecReg010", 
					align: "right", 
					width: 115, 
					ruptype: "datepicker", 
					resizable: true, 
					sortable: true
				},
				{ 	name: "nifEmpresa047", 
					align: "right", 
					width: 80,  
					resizable: true, 
					sortable: true
				},
				{ 	name: "razonSocial047", 
					align: "left", 
					width: 200, 
					resizable: true, 
					sortable: true
				},
				/*{ 	name: "provDo", 
					align: "left", 
					width: 150, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "munDo", 
					align: "left", 
					width: 150, 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fechIniTrabajo010",
					align: "left", 
					width: 115, 
					ruptype: "datepicker", 
					resizable: true, 
					sortable: true
				},*/
				{ 	name: "fase" + $.rup_utils.capitalizedLang(), 
					align: "left", 
					width: 200, 
					ruptype: "combo", 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "tramite" + $.rup_utils.capitalizedLang(), 
					align: "left", 
					width: 200, 
					ruptype: "combo", 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				}
	        ],
	        model:"Ab03b10v00",
	        usePlugins:[
	        	"feedback",
	        	"fluid",
	        	"toolbar",
	        	"multiselection",
	        	"formEdit",
	        	"filter"
	        ],
			primaryKey: "idExpediente",
			sortname: "idExpediente",
			sortorder: "asc",
			loadOnStartUp: false,
			feedback:{
				config:{
					block: false
				}
			},
			toolbar: {
				createDefaultToolButtons: false,
				buttons: []
			}
		});
	}else{
		$("#expFiltro").rup_table({
			url: "../expedientesCierre",
			colNames: [
				$.rup.i18n.app.expedientes.expediente,
				$.rup.i18n.app.expedientes.fecReg,
				$.rup.i18n.app.expedientes.cifNif,
				$.rup.i18n.app.expedientes.razonSocial,
				$.rup.i18n.app.expedientes.fase,
				$.rup.i18n.app.expedientes.tramite
			],
			colModel: [
				{ 	name: "idExpediente",
					align: "right", 
					width: 90, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fecReg010", 
					align: "right", 
					width: 115, 
					ruptype: "datepicker", 
					resizable: true, 
					sortable: true
				},
				{ 	name: "nifEmpresa047", 
					align: "right", 
					width: 80,  
					resizable: true, 
					sortable: true
				},
				{ 	name: "razonSocial047", 
					align: "left", 
					width: 200, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fase" + $.rup_utils.capitalizedLang(), 
					align: "left", 
					width: 200, 
					ruptype: "combo", 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "tramite" + $.rup_utils.capitalizedLang(), 
					align: "left", 
					width: 200, 
					ruptype: "combo", 
					fixed: false, 
					hidden: false, 
					resizable: true, 
					sortable: true
				}
	        ],
	        model:"Ab03b10v00",
	        usePlugins:[
	        	"feedback",
	        	"fluid",
	        	"toolbar",
	        	"formEdit",
	        	"filter"
	        ],
			primaryKey: "idExpediente",
			sortname: "idExpediente",
			sortorder: "asc",
			loadOnStartUp: false,
			feedback:{
				config:{
					block: false
				}
			},
			toolbar: {
				createDefaultToolButtons: false,
				buttons: []
			}
		});
	}

	$("#expFiltro").on("rupTable_beforeEditRow", 
		function(deleteOptions, selectedRow){
			if ($("#expFiltro_filter_form").validate().checkForm()) {
				fila = $("#expFiltro").rup_grid('getGridParam', 'selrow');
				obj = $("#expFiltro").rup_grid('getRowData', fila);

				window.location.href = $.rup.CTX_PATH + "ab03b10t00/irDetalle/"+obj.idExpediente;

				return false;
			} else {
				return false;
			}
		});	
	
	$("#expFiltro_filter_form").rup_validate({
		feedback:$("#expFiltro_feedback"),
		liveCheckingErrors: false,
		rules:{
			"idProv010":{digits:true},
			"idAno010":{digits:true},
			"id010":{digits:true}
		}
	});
	
	$("#expFiltro").on("rupTable_beforeFilter", 
	function(){
		if(ab03bUtils.form.validate($("#expFiltro_filter_form"))){	
			return true;
		} else {
			return false;
		}
	});	
});

function ocultar(capaAcordeon){
	$(capaAcordeon).toggle();
};

function cargarCombos(){
	
	$('#id001Fase').rup_combo({
		source : "/ab03bAmiantoWar/ab03b01t00/comboFase",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:false,
		blank:""
	});	
	
	
	$('#id002Tramite').rup_combo({
		source : "/ab03bAmiantoWar/ab03b02t00/comboTramite",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["id001Fase"],
		blank:""
	});
	
}

//Funcion limpiar
$('#expFiltro_filter_cleanLink').click(function(event){
	resetFiltro($("#expFiltro_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#expFiltro_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#expFiltro_feedback").rup_feedback("close");
	
	$("#expFiltro").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#expFiltro_filter_form")).remove();
});

function cerrarExpedientes(){
	if($("#expFiltro :checkbox:checked").length>0){
		
		var todosSeleccionados = $("#expFiltro").rup_table("getSelectedIds").selectedAll;
		$("#todosSeleccionados").val(todosSeleccionados);
		
		$("#seleccionados").val("");
		if ($("#expFiltro").rup_table("getSelectedIds").selectedIds != undefined) {
			$("#seleccionados").val($("#expFiltro").rup_table("getSelectedIds").selectedIds);
		} 
		
		var prov="";
		if (permisoDelegacion)
			prov= delegacionUsu;
		else
			prov= $('#idProv010').val();
		
		
		var urlCarga = "/ab03bAmiantoWar/expedientesCierre/cierreExp";
		// waitDialog();
		$.rup_ajax({
			url : urlCarga,
			dataType : 'json',
			data : {
				'seleccionados' : $("#seleccionados").val(),
				'todosSeleccionados' : todosSeleccionados,
				'fase': $('#id001Fase').val(),
				'tramite': $('#id002Tramite').val(),
				'prov': prov,
				'anyo': $('#idAno010').val(),
				'id': $('#id010').val()
			},
			cache : false,
			type : "GET",
			contentType : 'application/json',
			async : false,
			success : function(xhr, ajaxOptions) {
				// $.unblockUI();
				ab03bUtils.feedback.pintarFeedback($.rup.i18nParse($.rup.i18n.app,"mensajes.okGenerico"),  "ok",$("#expFiltro_feedback"));
				$("#expFiltro").rup_table("clearGridData", true);
				$("#expFiltro").rup_table("reloadGrid", false);
				//Cuando hay Multiseleccion::: Borro los registros seleccionados que han sido borrados
				$("#expFiltro").rup_table("resetSelection");
				//					
				//return null;

			},
			error : function(error){
				pintarFeedbackError(error.responseText, $("#expFiltro_feedback"));
			}
		});
	}else{
		//no hay ninguno seleccionado
		ab03bUtils.feedback.pintarFeedbackError($.rup.i18nParse($.rup.i18n.app,"mensajes.noSeleccion"), $("#expFiltro_feedback"));
		return false;
	}
}
